<?php
/**
 * Plugin Name: Zeitblock Shortcode
 * Description: Zeigt Inhalte nur innerhalb eines definierten Zeitraums (Datum + Uhrzeit) an.
 * Version: 1.0.0
 * Author: Armin Fischer . Computerservice.arminfischer.com office@arminfischer.com +4917621008967 . 
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Shortcode: [zeitblock von="YYYY-MM-DD HH:MM" bis="YYYY-MM-DD HH:MM"]
 */
function zeitblock_shortcode($atts, $content = null) {

    $atts = shortcode_atts([
        'von' => '',
        'bis' => ''
    ], $atts, 'zeitblock');

    // WordPress-Zeitzone
    $timezone = wp_timezone();

    try {
        $now = new DateTime('now', $timezone);

        $von = !empty($atts['von'])
            ? new DateTime($atts['von'], $timezone)
            : null;

        $bis = !empty($atts['bis'])
            ? new DateTime($atts['bis'], $timezone)
            : null;

    } catch (Exception $e) {
        return '';
    }

    // Logik
    if ($von && $now < $von) {
        return '';
    }

    if ($bis && $now > $bis) {
        return '';
    }

    return do_shortcode($content);
}

add_shortcode('zeitblock', 'zeitblock_shortcode');
